const express = require('express');
const mysql = require('mysql');
const cors = require('cors');
const bodyParser = require('body-parser');
const bcrypt = require('bcrypt'); // 添加 bcrypt 库

const app = express();
app.use(cors());
app.use(bodyParser.json());

// 数据库连接配置
const db = mysql.createPool({
    host: 'localhost',
    user: 'root',
    password: '123456',
    database: 'book'
});

// 登录API
app.post('/api/login', (req, res) => {
    const { username, password } = req.body;

    // 查询用户信息
    db.query(
        'SELECT * FROM `用户` WHERE `用户名` = ?',
        [username],
        (error, results) => {
            if (error) {
                console.error('查询错误:', error);
                res.status(500).json({ success: false, message: '服务器错误' });
                return;
            }

            if (results.length > 0) {
                // 比较密码
                bcrypt.compare(password, results[0].密码, (compareError, isMatch) => {
                    if (compareError) {
                        console.error('密码比较错误:', compareError);
                        res.status(500).json({ success: false, message: '服务器错误' });
                        return;
                    }

                    if (isMatch) {
                        // 登录成功，更新登录次数
                        const userId = results[0].id; // 获取用户ID
                        db.query(
                            'UPDATE `用户` SET `登录次数` = `登录次数` + 1 WHERE `id` = ?',
                            [userId],
                            (updateError, updateResult) => {
                                if (updateError) {
                                    console.error('更新登录次数错误:', updateError);
                                    res.status(500).json({ success: false, message: '服务器错误' });
                                } else {
                                    res.json({ 
                                        success: true, 
                                        message: '登录成功', 
                                        userId: userId, 
                                        nickname: results[0].用户昵称, 
                                        userGroup: results[0].用户组 // 确保返回用户组
                                    });
                                }
                            }
                        );
                    } else {
                        // 登录失败
                        res.json({ success: false, message: '用户名或密码错误' });
                    }
                });
            } else {
                // 登录失败
                res.json({ success: false, message: '用户名或密码错误' });
            }
        }
    );
});

// 注册API
app.post('/api/register', (req, res) => {
    const { username, password, nickname } = req.body;

    // 检查用户名是否已存在
    db.query(
        'SELECT * FROM `用户` WHERE `用户名` = ?',
        [username],
        (error, results) => {
            if (error) {
                console.error('查询错误:', error);
                res.status(500).json({ success: false, message: '服务器错误' });
                return;
            }

            if (results.length > 0) {
                // 用户名已存在
                res.json({ success: false, message: '用户名已存在' });
            } else {
                // 对密码进行哈希处理
                bcrypt.hash(password, 10, (hashError, hash) => {
                    if (hashError) {
                        console.error('哈希密码错误:', hashError);
                        res.status(500).json({ success: false, message: '服务器错误' });
                        return;
                    }

                    // 获取上一位用户的 id 值
                    db.query(
                        'SELECT MAX(`id`) AS maxId FROM `用户`',
                        (maxIdError, maxIdResult) => {
                            if (maxIdError) {
                                console.error('获取最大ID错误:', maxIdError);
                                res.status(500).json({ success: false, message: '服务器错误' });
                                return;
                            }

                            // 生成新的 id 值
                            const newId = maxIdResult[0].maxId !== null ? maxIdResult[0].maxId + 1 : 1;

                            // 用户名不存在，插入新用户
                            db.query(
                                'INSERT INTO `用户` (`id`, `用户名`, `密码`, `用户昵称`, `用户组`, `登录次数`) VALUES (?, ?, ?, ?, "普通用户", 0)',
                                [newId, username, hash, nickname],
                                (insertError, insertResult) => {
                                    if (insertError) {
                                        console.error('插入用户错误:', insertError);
                                        res.status(500).json({ success: false, message: '服务器错误' });
                                    } else {
                                        // 获取生成的 id 值
                                        const userId = newId;
                                        res.json({ 
                                            success: true, 
                                            message: '注册成功', 
                                            userId: userId, 
                                            nickname: nickname, 
                                            userGroup: "普通用户" // 确保返回用户组
                                        });
                                    }
                                }
                            );
                        }
                    );
                });
            }
        }
    );
});

// 获取用户数量API
app.get('/api/user-count', (req, res) => {
    db.query(
        'SELECT COUNT(*) AS userCount FROM `用户`',
        (error, results) => {
            if (error) {
                console.error('查询错误:', error);
                res.status(500).json({ success: false, message: '服务器错误' });
                return;
            }

            res.json({ success: true, userCount: results[0].userCount });
        }
    );
});

// 启动服务器
app.listen(3000, () => {
    console.log('服务器运行在端口 3000');
});
